# -*- coding: utf-8 -*-

#EXT_FORCES.PY
#@author: Thomas Gillis
#
#Created on 1/7/2013
#Last update on 9/7/2013
#
#Copyright 2013 Universite Catholique de Louvain

import numpy as np
import math
from MBsysPy import cross_product


def user_ExtForces(PxF,RxF,VxF,OMxF,AxF,OMPxF,mbs_data,tsim,ixF):
    """ Compute the external force for a given force point

    :param PxF: the position of the point
    :param RxF: the rotation matrix of the point
    :param VxF: the velocity vector of the point
    :param OMxF: the angular velocity of the point
    :param AxF: the acceleration vector of the point
    :param OMPxF: the angular acceleration of the point
    :param mbs: the Data structure
    :param tsim: the simulation time
    :param ixF: the index of the force point
    
    """
    
    Fx=0.0
    Fy=0.0
    Fz=0.0
    Mx=0.0
    My=0.0
    Mz=0.0
    idpt=mbs_data.xfidpt[ixF]
    dxF=mbs_data.dpt[1:,idpt]

    #print(PxF[1], PxF[2], PxF[3])
    #print(RxF)
#==============================================================================
# BEGIN OF USER CODE
#==============================================================================


    # nB: Unit vector perpendicualr to wheel plane
    nB = np.zeros(4)
    nB[1]=RxF[2][1] 
    nB[2]=RxF[2][2]
    nB[3]=RxF[2][3]
    
    # nS: Unit vector in the direction of the positive z-axis 
    nS = np.zeros(4)
    nS[3] = 1.0
    
    # nL
    nL = cross_product(nB, nS)
    
    # cosphi: camber angle
    gamma = - math.asin(nB[3])
    cosphi = math.cos(gamma)
    
    # steer angle
    delta = math.atan(nL[2]/nL[1])

    
    z_poster = mbs_data.q[mbs_data.joint_id["T3_poster"]]
    K_wheel  = mbs_data.user_model['WHEEL']['K']
    R_wheel  = mbs_data.user_model['WHEEL']['rnom']
    
    e = PxF[3] - z_poster - R_wheel*cosphi

    if e < 0.0:
        dxF[2] = - PxF[3] + z_poster
    else:
        dxF[2] = - R_wheel * cosphi
         
    if mbs_data.process == 2:
        Fz = -K_wheel * e
        
    else:
        if e > 0.0:
            Fz = 0.0
        else:
            Fz = - K_wheel * e 

    if mbs_data.process == 51:
        mbs_data.set_output_value(PxF[1], 1, "kinematics")
        mbs_data.set_output_value(PxF[2], 2, "kinematics")
        mbs_data.set_output_value(PxF[3], 3, "kinematics")
        mbs_data.set_output_value(gamma, 4, "kinematics")
        mbs_data.set_output_value(delta, 5, "kinematics")
        
    if mbs_data.process == 31:
        mbs_data.set_output(Fz,'Fz')
        mbs_data.set_output(AxF[3],'Az')
        mbs_data.set_output(VxF[3],'Vz')
        mbs_data.set_output(PxF[3],'Pz') 
           
    else:
        mbs_data.set_output(Fz,'Fz')
        mbs_data.set_output(AxF[2],'A')
        mbs_data.set_output(VxF[2],'V')
        mbs_data.set_output(PxF[2],'P')
        mbs_data.set_output(PxF[3],'Pz')
        mbs_data.set_output(VxF[3],'Vz')
        mbs_data.set_output(AxF[3],'Az')
#==============================================================================
# END OF USER CODE
#==============================================================================

    Swr=np.zeros(9+1)
    Swr[1:]=np.r_[Fx,Fy,Fz,Mx,My,Mz,dxF]
    
    return Swr
